<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Insights
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Options;
use Twilio\Values;

abstract class CallSummariesOptions
{
    /**
     * @param string $from 
     * @param string $to 
     * @param string $fromCarrier 
     * @param string $toCarrier 
     * @param string $fromCountryCode 
     * @param string $toCountryCode 
     * @param bool $branded 
     * @param bool $verifiedCaller 
     * @param bool $hasTag 
     * @param string $startTime 
     * @param string $endTime 
     * @param string $callType 
     * @param string $callState 
     * @param string $direction 
     * @param string $processingState 
     * @param string $sortBy 
     * @param string $subaccount 
     * @param bool $abnormalSession 
     * @param string $answeredBy 
     * @param string $connectivityIssue 
     * @param string $qualityIssue 
     * @param bool $spam 
     * @param string $callScore 
     * @return ReadCallSummariesOptions Options builder
     */
    public static function read(
        
        string $from = Values::NONE,
        string $to = Values::NONE,
        string $fromCarrier = Values::NONE,
        string $toCarrier = Values::NONE,
        string $fromCountryCode = Values::NONE,
        string $toCountryCode = Values::NONE,
        bool $branded = Values::BOOL_NONE,
        bool $verifiedCaller = Values::BOOL_NONE,
        bool $hasTag = Values::BOOL_NONE,
        string $startTime = Values::NONE,
        string $endTime = Values::NONE,
        string $callType = Values::NONE,
        string $callState = Values::NONE,
        string $direction = Values::NONE,
        string $processingState = Values::NONE,
        string $sortBy = Values::NONE,
        string $subaccount = Values::NONE,
        bool $abnormalSession = Values::BOOL_NONE,
        string $answeredBy = Values::NONE,
        string $connectivityIssue = Values::NONE,
        string $qualityIssue = Values::NONE,
        bool $spam = Values::BOOL_NONE,
        string $callScore = Values::NONE

    ): ReadCallSummariesOptions
    {
        return new ReadCallSummariesOptions(
            $from,
            $to,
            $fromCarrier,
            $toCarrier,
            $fromCountryCode,
            $toCountryCode,
            $branded,
            $verifiedCaller,
            $hasTag,
            $startTime,
            $endTime,
            $callType,
            $callState,
            $direction,
            $processingState,
            $sortBy,
            $subaccount,
            $abnormalSession,
            $answeredBy,
            $connectivityIssue,
            $qualityIssue,
            $spam,
            $callScore
        );
    }

}

class ReadCallSummariesOptions extends Options
    {
    /**
     * @param string $from 
     * @param string $to 
     * @param string $fromCarrier 
     * @param string $toCarrier 
     * @param string $fromCountryCode 
     * @param string $toCountryCode 
     * @param bool $branded 
     * @param bool $verifiedCaller 
     * @param bool $hasTag 
     * @param string $startTime 
     * @param string $endTime 
     * @param string $callType 
     * @param string $callState 
     * @param string $direction 
     * @param string $processingState 
     * @param string $sortBy 
     * @param string $subaccount 
     * @param bool $abnormalSession 
     * @param string $answeredBy 
     * @param string $connectivityIssue 
     * @param string $qualityIssue 
     * @param bool $spam 
     * @param string $callScore 
     */
    public function __construct(
        
        string $from = Values::NONE,
        string $to = Values::NONE,
        string $fromCarrier = Values::NONE,
        string $toCarrier = Values::NONE,
        string $fromCountryCode = Values::NONE,
        string $toCountryCode = Values::NONE,
        bool $branded = Values::BOOL_NONE,
        bool $verifiedCaller = Values::BOOL_NONE,
        bool $hasTag = Values::BOOL_NONE,
        string $startTime = Values::NONE,
        string $endTime = Values::NONE,
        string $callType = Values::NONE,
        string $callState = Values::NONE,
        string $direction = Values::NONE,
        string $processingState = Values::NONE,
        string $sortBy = Values::NONE,
        string $subaccount = Values::NONE,
        bool $abnormalSession = Values::BOOL_NONE,
        string $answeredBy = Values::NONE,
        string $connectivityIssue = Values::NONE,
        string $qualityIssue = Values::NONE,
        bool $spam = Values::BOOL_NONE,
        string $callScore = Values::NONE

    ) {
        $this->options['from'] = $from;
        $this->options['to'] = $to;
        $this->options['fromCarrier'] = $fromCarrier;
        $this->options['toCarrier'] = $toCarrier;
        $this->options['fromCountryCode'] = $fromCountryCode;
        $this->options['toCountryCode'] = $toCountryCode;
        $this->options['branded'] = $branded;
        $this->options['verifiedCaller'] = $verifiedCaller;
        $this->options['hasTag'] = $hasTag;
        $this->options['startTime'] = $startTime;
        $this->options['endTime'] = $endTime;
        $this->options['callType'] = $callType;
        $this->options['callState'] = $callState;
        $this->options['direction'] = $direction;
        $this->options['processingState'] = $processingState;
        $this->options['sortBy'] = $sortBy;
        $this->options['subaccount'] = $subaccount;
        $this->options['abnormalSession'] = $abnormalSession;
        $this->options['answeredBy'] = $answeredBy;
        $this->options['connectivityIssue'] = $connectivityIssue;
        $this->options['qualityIssue'] = $qualityIssue;
        $this->options['spam'] = $spam;
        $this->options['callScore'] = $callScore;
    }

    /**
     * 
     *
     * @param string $from 
     * @return $this Fluent Builder
     */
    public function setFrom(string $from): self
    {
        $this->options['from'] = $from;
        return $this;
    }

    /**
     * 
     *
     * @param string $to 
     * @return $this Fluent Builder
     */
    public function setTo(string $to): self
    {
        $this->options['to'] = $to;
        return $this;
    }

    /**
     * 
     *
     * @param string $fromCarrier 
     * @return $this Fluent Builder
     */
    public function setFromCarrier(string $fromCarrier): self
    {
        $this->options['fromCarrier'] = $fromCarrier;
        return $this;
    }

    /**
     * 
     *
     * @param string $toCarrier 
     * @return $this Fluent Builder
     */
    public function setToCarrier(string $toCarrier): self
    {
        $this->options['toCarrier'] = $toCarrier;
        return $this;
    }

    /**
     * 
     *
     * @param string $fromCountryCode 
     * @return $this Fluent Builder
     */
    public function setFromCountryCode(string $fromCountryCode): self
    {
        $this->options['fromCountryCode'] = $fromCountryCode;
        return $this;
    }

    /**
     * 
     *
     * @param string $toCountryCode 
     * @return $this Fluent Builder
     */
    public function setToCountryCode(string $toCountryCode): self
    {
        $this->options['toCountryCode'] = $toCountryCode;
        return $this;
    }

    /**
     * 
     *
     * @param bool $branded 
     * @return $this Fluent Builder
     */
    public function setBranded(bool $branded): self
    {
        $this->options['branded'] = $branded;
        return $this;
    }

    /**
     * 
     *
     * @param bool $verifiedCaller 
     * @return $this Fluent Builder
     */
    public function setVerifiedCaller(bool $verifiedCaller): self
    {
        $this->options['verifiedCaller'] = $verifiedCaller;
        return $this;
    }

    /**
     * 
     *
     * @param bool $hasTag 
     * @return $this Fluent Builder
     */
    public function setHasTag(bool $hasTag): self
    {
        $this->options['hasTag'] = $hasTag;
        return $this;
    }

    /**
     * 
     *
     * @param string $startTime 
     * @return $this Fluent Builder
     */
    public function setStartTime(string $startTime): self
    {
        $this->options['startTime'] = $startTime;
        return $this;
    }

    /**
     * 
     *
     * @param string $endTime 
     * @return $this Fluent Builder
     */
    public function setEndTime(string $endTime): self
    {
        $this->options['endTime'] = $endTime;
        return $this;
    }

    /**
     * 
     *
     * @param string $callType 
     * @return $this Fluent Builder
     */
    public function setCallType(string $callType): self
    {
        $this->options['callType'] = $callType;
        return $this;
    }

    /**
     * 
     *
     * @param string $callState 
     * @return $this Fluent Builder
     */
    public function setCallState(string $callState): self
    {
        $this->options['callState'] = $callState;
        return $this;
    }

    /**
     * 
     *
     * @param string $direction 
     * @return $this Fluent Builder
     */
    public function setDirection(string $direction): self
    {
        $this->options['direction'] = $direction;
        return $this;
    }

    /**
     * 
     *
     * @param string $processingState 
     * @return $this Fluent Builder
     */
    public function setProcessingState(string $processingState): self
    {
        $this->options['processingState'] = $processingState;
        return $this;
    }

    /**
     * 
     *
     * @param string $sortBy 
     * @return $this Fluent Builder
     */
    public function setSortBy(string $sortBy): self
    {
        $this->options['sortBy'] = $sortBy;
        return $this;
    }

    /**
     * 
     *
     * @param string $subaccount 
     * @return $this Fluent Builder
     */
    public function setSubaccount(string $subaccount): self
    {
        $this->options['subaccount'] = $subaccount;
        return $this;
    }

    /**
     * 
     *
     * @param bool $abnormalSession 
     * @return $this Fluent Builder
     */
    public function setAbnormalSession(bool $abnormalSession): self
    {
        $this->options['abnormalSession'] = $abnormalSession;
        return $this;
    }

    /**
     * 
     *
     * @param string $answeredBy 
     * @return $this Fluent Builder
     */
    public function setAnsweredBy(string $answeredBy): self
    {
        $this->options['answeredBy'] = $answeredBy;
        return $this;
    }

    /**
     * 
     *
     * @param string $connectivityIssue 
     * @return $this Fluent Builder
     */
    public function setConnectivityIssue(string $connectivityIssue): self
    {
        $this->options['connectivityIssue'] = $connectivityIssue;
        return $this;
    }

    /**
     * 
     *
     * @param string $qualityIssue 
     * @return $this Fluent Builder
     */
    public function setQualityIssue(string $qualityIssue): self
    {
        $this->options['qualityIssue'] = $qualityIssue;
        return $this;
    }

    /**
     * 
     *
     * @param bool $spam 
     * @return $this Fluent Builder
     */
    public function setSpam(bool $spam): self
    {
        $this->options['spam'] = $spam;
        return $this;
    }

    /**
     * 
     *
     * @param string $callScore 
     * @return $this Fluent Builder
     */
    public function setCallScore(string $callScore): self
    {
        $this->options['callScore'] = $callScore;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.ReadCallSummariesOptions ' . $options . ']';
    }
}

