<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('backend/css/codemirror.css')); ?>" rel='stylesheet'>
    <link href="<?php echo e(asset('backend/css/ayu-dark.css')); ?>" rel='stylesheet'>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add Custom CSS')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Add Custom CSS')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="paragraph mb-4"><i icon-name="alert-triangle"></i>You can add <strong>Custom
                                    CSS</strong> to write the css below and it will effect on the <strong>User Front End
                                    Pages</strong></div>
                            <form action="<?php echo e(route('admin.custom-css.update')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="site-input-groups">
                                    <textarea name="custom_css"
                                              class="form-textarea editorContainer"><?php echo e($customCss); ?></textarea>
                                </div>
                                <button type="submit" class="site-btn-sm primary-btn">
                                    <?php echo e(__('Save Changes')); ?>

                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('backend/js/codemirror.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/code-css.js')); ?>"></script>
    <script>
        (() => {
            'use strict';
            var editorContainer = document.querySelector('.editorContainer')

            var editor = CodeMirror.fromTextArea(editorContainer, {
                lineNumbers: true,
                mode: 'css',
                theme: 'ayu-dark',
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\demo\resources\views/backend/css_manage/index.blade.php ENDPATH**/ ?>