<?php $__env->startSection('setting-title'); ?>
    <?php echo e(__('Mail Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Mail Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('setting-content'); ?>

    <div class="col-xl-8 col-lg-12 col-md-12 col-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Mail Settings')); ?></h3>
                <div class="card-header-links">
                    <a data-bs-toggle="modal" data-bs-target="#mailConnection" href="javascript:void(0);"
                       class="card-header-link"> <i icon-name="mail-check"></i> <?php echo e(__('Connection Check')); ?></a>
                </div>
            </div>
            <div class="site-card-body">
                <form action="<?php echo e(route('admin.settings.update')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="section" value="mail">
                    <div class="site-input-groups row mb-0">
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                            <?php echo e(__('Mail Setting')); ?>

                        </div>
                        <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                            <div class="form-row row">
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for=""
                                               class="box-input-label col-label"><?php echo e(__('Email From Name')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="email_from_name"
                                            value="<?php echo e(setting('email_from_name','mail')); ?>"
                                            required
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for=""
                                               class="box-input-label col-label"><?php echo e(__('Email From Address')); ?></label>
                                        <input
                                            type="email"
                                            class="box-input"
                                            name="email_from_address"
                                            value="<?php echo e(setting('email_from_address','mail')); ?>"
                                            required
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label pt-0">
                            <?php echo e(__('Mailing Driver')); ?>

                        </div>

                        <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                            <div class="site-input-groups">

                                <div class="form-check">
                                    <input
                                        class="form-check-input"
                                        type="radio"
                                        name="mailing_driver"
                                        id="smtp"
                                        value="smtp"
                                        checked=""
                                    />
                                    <label class="form-check-label col-label pt-0" for="smtp">
                                        <?php echo e(__('SMTP')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                            <?php echo e(__('Configuration')); ?>

                        </div>
                        <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                            <div class="form-row row">
                                <div class="col-xl-6 col-md-6 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label"><?php echo e(__('Mail Username')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="mail_username"
                                            value="<?php echo e(setting('mail_username','mail')); ?>"
                                            required=""
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label"><?php echo e(__('Mail Password')); ?></label>
                                        <input
                                            type="password"
                                            class="box-input"
                                            name="mail_password"
                                            value="<?php echo e(!config('app.demo') ? setting('mail_password','mail') : 'demo-mode'); ?>"
                                            required=""
                                        />
                                    </div>
                                </div>
                            </div>
                            <div class="form-row row">
                                <div class="col-xl-6 col-md-6 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label"><?php echo e(__('SMTP Host')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="mail_host"
                                            value="<?php echo e(setting('mail_host','mail')); ?>"
                                            required=""
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-3 col-md-3 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label"><?php echo e(__('SMTP Port')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="mail_port"
                                            value="<?php echo e(setting('mail_port','mail')); ?>"
                                            required=""
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-3 col-md-3 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="" class="box-input-label"><?php echo e(__('SMTP Secure')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="mail_secure"
                                            value="<?php echo e(setting('mail_secure','mail')); ?>"
                                            required=""
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="offset-sm-3 col-sm-9 col-12">
                            <button type="submit" class="site-btn-sm primary-btn w-100">
                                <?php echo e(__(' Save Changes')); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    

    <div
        class="modal fade"
        id="mailConnection"
        tabindex="-1"
        aria-labelledby="mailConnectionLabel"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content site-table-modal">
                <div class="modal-header">
                    <h5 class="modal-title" id="mailConnectionLabel">
                        <?php echo e(__('SMTP Connection')); ?>

                    </h5>
                    <button
                        type="button"
                        class="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                    ></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('admin.settings.mail.connection.test')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="col-xl-12">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Your Email:')); ?></label>
                                    <input
                                        type="email"
                                        name="email"
                                        class="box-input mb-0"
                                        required=""
                                    />
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <button type="submit" class="site-btn primary-btn w-100">
                                    <?php echo e(__('Check Now')); ?>

                                </button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.setting.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\demo\resources\views/backend/setting/mail.blade.php ENDPATH**/ ?>