<?php $__env->startSection('setting-title'); ?>
    <?php echo e(__('Plugin Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Plugin Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('setting-content'); ?>
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e($title); ?></h3>
                <?php if($isLink): ?>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('admin.settings.notification.tune')); ?>" class="card-header-link new-referral"
                           type="button" data-type="investment">
                            <i icon-name="volume-1"></i><?php echo e(__('Set Tune')); ?></a>
                    </div>

                <?php endif; ?>

            </div>
            <div class="site-card-body">
                <p class="paragraph">
                    <i icon-name="info"></i><?php echo e(__('You can')); ?>

                    <strong><?php echo e(__('Enable or Disable')); ?></strong> <?php echo e(__('any of the plugin')); ?>

                </p>
                <?php $__currentLoopData = $plugins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-gateway">
                        <div class="gateway-name">
                            <div class="gateway-icon">
                                <img
                                    src="<?php echo e(asset($plugin->icon)); ?>" alt=""/>
                            </div>
                            <div class="gateway-title">
                                <h4><?php echo e($plugin->name); ?></h4>
                                <p><?php echo e($plugin->description); ?></p>
                            </div>
                        </div>
                        <div class="gateway-right">
                            <div class="gateway-status">
                                <?php if($plugin->status): ?>
                                    <div class="site-badge success"><?php echo e(__('Activated')); ?></div>
                                <?php else: ?>
                                    <div class="site-badge pending"><?php echo e(__('DeActivated')); ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="gateway-edit">
                                <a type="button" class="editPlugin" data-id="<?php echo e($plugin->id); ?>"><i
                                        icon-name="settings-2"></i></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </div>

    <!-- Modal for Edit Plugin -->
    <div
        class="modal fade"
        id="editPlugin"
        tabindex="-1"
        aria-labelledby="editPluginModalLabel"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content site-table-modal">
                <div class="modal-body popup-body">
                    <button
                        type="button"
                        class="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                    ></button>
                    <div class="popup-body-text edit-plugin-section">

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal for Edit Plugin-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>
        $('.editPlugin').on('click', function (e) {
            "use strict"
            var id = $(this).data('id');
            $('.edit-plugin-section').empty();

            var url = '<?php echo e(route("admin.settings.plugin.data",":id")); ?>';
            url = url.replace(':id', id);
            $.get(url, function ($data) {
                $('.edit-plugin-section').append($data)
                $('#editPlugin').modal('show');

            })

        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.setting.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bit\app\resources\views/backend/setting/plugin/index.blade.php ENDPATH**/ ?>