<?php $__env->startSection('title'); ?>
    <?php echo e(__('Automatic Payment Gateway')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Automatic Payment Gateway')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo e(__('Logo')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Supported Currency')); ?></th>
                                <th><?php echo e(__('Withdraw Available')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Manage')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <img height="25" src="<?php echo e(asset($gateway->logo)); ?>" alt="">
                                    </td>
                                    <td><?php echo e($gateway->name); ?></td>
                                    <td> <?php echo e(count(json_decode($gateway->supported_currencies,true))); ?></td>
                                    <td>
                                        <?php if($gateway->is_withdraw != 0): ?>
                                            <div class="site-badge success"> <?php echo e(__('Yes')); ?></div>
                                        <?php else: ?>
                                            <div class="site-badge pending">  <?php echo e(__('No')); ?></div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($gateway->status == 1): ?>
                                            <div class="site-badge success"> <?php echo e(__('Activated')); ?></div>
                                        <?php else: ?>
                                            <div class="site-badge pending">  <?php echo e(__('Deactivated')); ?></div>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <button
                                            class="round-icon-btn primary-btn"
                                            type="button"
                                            data-bs-toggle="modal"
                                            data-bs-target="#manage-<?php echo e($gateway->id); ?>"
                                        >
                                            <i icon-name="settings-2"></i>
                                        </button>
                                    </td>
                                </tr>


                                <!--  Manage Modal -->
                                <?php echo $__env->make('backend.automatic_gateway.include.__manage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <!-- Manage Modal End-->

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>

                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\demo\resources\views/backend/automatic_gateway/index.blade.php ENDPATH**/ ?>