<?php $__env->startSection('title'); ?>
    <?php echo e(__('All Schema')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('All Investment Plan')); ?></h3>
                </div>
                <div class="site-card-body">
                    <div class="row">
                        <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-xxl-3 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                <div class="single-investment-plan">
                                    <img
                                        class="investment-plan-icon"
                                        src="<?php echo e(asset($schema->icon)); ?>"
                                        alt=""
                                    />
                                    <?php if($schema->badge): ?>
                                        <div class="feature-plan"><?php echo e($schema->badge); ?></div>
                                    <?php endif; ?>

                                    <h3><?php echo e($schema->name); ?></h3>
                                    <p><?php echo e($schema->schedule->name . ' '. ($schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $currencySymbol.$schema->return_interest )); ?></p>
                                    <ul>
                                        <li><?php echo e(__('Investment')); ?> <span class="special">
                                            <?php echo e($schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount); ?>

                                        </span></li>
                                        <li><?php echo e(__('Capital Back')); ?>

                                            <span><?php echo e($schema->capital_back ? 'Yes' : 'No'); ?></span></li>
                                        <li><?php echo e(__('Return Type')); ?> <span><?php echo e(ucwords($schema->return_type)); ?></span>
                                        </li>
                                        <li><?php echo e(__('Number of Period')); ?>

                                            <span><?php echo e(($schema->return_type == 'period' ? $schema->number_of_period : 'Unlimited').($schema->number_of_period == 1 ? ' Time' : ' Times' )); ?></span>
                                        </li>
                                        <li><?php echo e(__('Profit Withdraw')); ?> <span><?php echo e(__('Anytime')); ?></span></li>
                                        <li><?php echo e(__('Cancel')); ?> <span> <?php if($schema->schema_cancel): ?>
                                                    <?php echo e(__('Within').' '. $schema->expiry_minute .' '. 'Minute'); ?>

                                                <?php else: ?>
                                                    <?php echo e(__('No')); ?>

                                                <?php endif; ?></span></li>
                                    </ul>
                                    <div class="holidays"><span class="star">*</span><?php if( null != $schema->off_days): ?>
                                            <?php echo e(implode(', ', json_decode($schema->off_days,true))  .' '.__('are')); ?>

                                        <?php else: ?>
                                            <?php echo e(__('No Profit')); ?>

                                        <?php endif; ?> <?php echo e(__('Holidays')); ?></div>
                                    <a href="<?php echo e(route('user.schema.preview',$schema->id)); ?>"
                                       class="site-btn grad-btn w-100 centered"><i
                                            class="anticon anticon-check"></i><?php echo e(__('Invest Now')); ?></a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\invest\app\app\Providers/../../resources/views/frontend/default/schema/index.blade.php ENDPATH**/ ?>