<?php $__env->startSection('theme-title'); ?>
    <?php echo e(__('Dynamic Landing Theme')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('theme-content'); ?>
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Dynamic Landing Theme')); ?></h3>
                <form action="<?php echo e(route('admin.theme.dynamic-landing-update')); ?>" method="post"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-header-links">
                        <div class="card-header-links new-referral">
                            <div class="input-group joint-input">
                                <input type="file" placeholder="hfh" name="theme_file" class="form-control" required/>
                                <button type="submit" class="input-group-text"><i icon-name="upload-cloud"></i></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class="site-card-body">
                <p class="paragraph">
                    <i icon-name="info"></i><?php echo e(__('You can upload your own HTML template here as a website Home page and other pages. You need to add ')); ?>

                    <strong> @lasset('landing asset')</strong> <?php echo e(__(' for any assets support on the theme')); ?>

                </p>
                <?php $__currentLoopData = $landingThemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-gateway">
                        <div class="gateway-name">
                            <div class="gateway-icon">
                                <i icon-name="feather"></i>
                            </div>
                            <div class="gateway-title">
                                <h4><?php echo e($theme->name); ?></h4>
                            </div>
                        </div>
                        <div class="gateway-right">
                            <div class="gateway-status">
                                <div class="switch-field mb-0">
                                    <input
                                        type="radio"
                                        id="theme-status<?php echo e($theme->id); ?>"
                                        class="theme-status"
                                        name="status<?php echo e($theme->id); ?>"
                                        value="1"
                                        data-id="<?php echo e($theme->id); ?>"
                                        <?php if($theme->status): ?> checked <?php endif; ?>
                                    />
                                    <label for="theme-status<?php echo e($theme->id); ?>"><?php echo e(__('Active')); ?></label>
                                    <input
                                        type="radio"
                                        id="theme-status-no<?php echo e($theme->id); ?>"
                                        name="status<?php echo e($theme->id); ?>"
                                        class="theme-status"
                                        value="0"
                                        data-id="<?php echo e($theme->id); ?>"
                                        <?php if(!$theme->status): ?> checked <?php endif; ?>

                                    />
                                    <label for="theme-status-no<?php echo e($theme->id); ?>"><?php echo e(__('DeActive')); ?></label>
                                </div>

                            </div>
                            <div class="gateway-edit">
                                <button type="button" data-id="<?php echo e($theme->id); ?>"
                                        data-name="<?php echo e($theme->name); ?>"
                                        class="round-icon-btn red-btn deleteLandingTheme">
                                    <i icon-name="trash-2"></i> <?php echo e(__('Delete')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </div>

    <!-- Modal for Delete Theme Lending -->
    <div
        class="modal fade"
        id="deleteLandingTheme"
        tabindex="-1"
        aria-labelledby="deleteLandingThemeModalLabel"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-md modal-dialog-centered">
            <div class="modal-content site-table-modal">
                <div class="modal-body popup-body">
                    <button
                        type="button"
                        class="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                    ></button>
                    <div class="popup-body-text centered">
                        <form method="post" id="themeLandingDeleteForm">
                            <?php echo csrf_field(); ?>
                            <div class="info-icon">
                                <i icon-name="alert-triangle"></i>
                            </div>
                            <div class="title">
                                <h4><?php echo e(__('Are you sure?')); ?></h4>
                            </div>
                            <p>
                                <?php echo e(__('You want to Delete')); ?> <strong
                                    class="name"></strong> <?php echo e(__('landing Theme?')); ?>

                            </p>
                            <div class="action-btns">
                                <button type="submit" class="site-btn-sm primary-btn me-2">
                                    <i icon-name="check"></i>
                                    <?php echo e(__(' Confirm')); ?>

                                </button>
                                <a href="" class="site-btn-sm red-btn" type="button"
                                   class="btn-close"
                                   data-bs-dismiss="modal"
                                   aria-label="Close">
                                    <i icon-name="x"></i>
                                    <?php echo e(__('Cancel')); ?>

                                </a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal for Delete Plugin-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>
        $('.theme-status').on('click', function (e) {
            "use strict"
            var id = $(this).data('id');
            var status = parseInt($(this).val());
            var url = '<?php echo e(route("admin.theme.status-update")); ?>';
            $.ajax({
                url: url,
                type: 'GET',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    var oldStatus = data.old_status
                    for (var i = 0; i < oldStatus.length; i++) {
                        $('#theme-status' + oldStatus[i]).prop('checked', false);
                        $('#theme-status-no' + oldStatus[i]).prop('checked', true);

                    }
                    tNotify('success', data.message);
                }
            });


        })


        $('.deleteLandingTheme').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            var name = $(this).data('name');

            var url = '<?php echo e(route("admin.theme.dynamic-landing-delete", ":id")); ?>';
            url = url.replace(':id', id);
            $('#themeLandingDeleteForm').attr('action', url)

            $('.name').html(name);
            $('#deleteLandingTheme').modal('show');
        })

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.theme.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\demo\resources\views/backend/theme/dynamic_landing.blade.php ENDPATH**/ ?>